/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.controleurs;

import fr.asip.cps3.exemple.controleurs.ApplicationVue;
import fr.asip.cps3.exemple.controleurs.EcranControleur;
import fr.asip.cps3.exemple.controleurs.MenuControleur;
import fr.asip.cps3.exemple.modele.Application;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionControleur;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie;
import fr.asip.cps3.exemple.vues.menus.ItemMenu;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationControleur {
    private static Logger log = Logger.getLogger(ApplicationControleur.class);
    public ApplicationVue fenetrePrincipale = null;
    private Application application = null;

    public ApplicationControleur(Application application) throws ExceptionProgrammeExemple {
        this.fenetrePrincipale = new FenetrePrincipale(this, application);
        this.application = application;
        this.ajouteEcouteursApplication();
    }

    private void ajouteEcouteursApplication() throws ExceptionControleur {
        if (this.application == null) {
            log.error((Object)"L'application vaut nul. Il est impossible d'ajouter des \u00e9couteurs");
            throw new ExceptionControleur(301, "Une erreur inattendue est survenue");
        }
        this.application.ajouteApplicationEcouteur(this.fenetrePrincipale);
    }

    public void afficheFenetrePrincipale() throws ExceptionControleur {
        if (this.fenetrePrincipale == null) {
            log.error((Object)"La fen\u00eatre principale vaut nul. Il est impossible de l'afficher");
            throw new ExceptionControleur(301, "Une erreur inattendue est survenue");
        }
        this.fenetrePrincipale.affiche();
    }

    public void fermeFenetrePrincipale() throws ExceptionControleur {
        if (this.fenetrePrincipale == null) {
            log.error((Object)"La fen\u00eatre principale vaut nul. Il est impossible de la fermer");
            throw new ExceptionControleur(301, "Une erreur inattendue est survenue");
        }
        this.fenetrePrincipale.ferme();
    }

    public void declencheOperationMenu(Object object) {
        MenuControleur.executeOperation(this.application, (ItemMenu)object);
    }

    public Vector<String> declencheValidationSaisie(Saisie saisie) {
        return EcranControleur.valideSaisie(this.application, saisie);
    }

    public void declencheOperationSaisie(Saisie saisie) {
        EcranControleur.executeOperation(this.application, saisie);
    }

    public void declencheChargementLibrairie(String string) throws ExceptionControleur {
        if (this.application == null) {
            log.error((Object)"L'application vaut nul. Il est impossible de d\u00e9clencher le chargement de la librairie");
            throw new ExceptionControleur(301, "Une erreur inattendue est survenue");
        }
        this.application.setLibrairieP11(string);
        this.application.supprimeTousLesElementsEnCours();
        MenuControleur.refresh(this.application, "3,0");
    }

    public void deverrouilleMenu() {
        MenuControleur.deverrouille(this.application);
    }

    public void verrouilleMenu() {
        MenuControleur.verrouille(this.application);
    }
}

